﻿using Microsoft.Research.Oslo;
using OxyPlot;
using OxyPlot.Series;

using System;
using System.IO;
using System.Windows.Forms;

namespace Model_Lotki_Voltery
{
    internal enum SolType
    {
        podstawowy, odlawianie, srodowisko, kryjowki, konkurencja, symbioza
    }

    public partial class MainForm : Form
    {
        private SolPoint[][] dataToSave = new SolPoint[6][];

        private readonly DataModel _model = new DataModel();

        private ToolTip[] toolTip = new ToolTip[4];

        public MainForm()
        {
            InitializeComponent();
            WindowState = FormWindowState.Maximized;
            for (int i = 0; i < toolTip.Length; i++)
            {
                toolTip[i] = new ToolTip();
                toolTip[i].IsBalloon = true;
                toolTip[i].InitialDelay = 0;
                toolTip[i].ShowAlways = true;
            }

            toolTip[0].SetToolTip(konkurencja_konkurencjaGatunkuIzJ, "Jak mocno gatunek J wypiera gatunek I.");
            toolTip[1].SetToolTip(konkurencja_konkurencjaGatunkuJzI, "Jak mocno gatunek I wypiera gatunek J.");
            toolTip[2].SetToolTip(symbioza_symbiozaGatunkuIzJ, "Jak mocno gatunek I wspomaga gatunek J.");
            toolTip[3].SetToolTip(symbioza_symbiozaGatunkuJzI, "Jak mocno gatunek J wspomaga gatunek I.");
        }

        private void policz_podstawowy_Click(object sender, EventArgs e)
        {
            PoliczClick(SolType.podstawowy);
        }

        private void zapisz_podstawowy_Click(object sender, EventArgs e)
        {
            ZapiszClick(SolType.podstawowy);
        }

        private void policz_odlawianie_Click(object sender, EventArgs e)
        {
            PoliczClick(SolType.odlawianie);
        }

        private void zapisz_odlawianie_Click(object sender, EventArgs e)
        {
            ZapiszClick(SolType.odlawianie);
        }

        private void policz_srodowiska_Click(object sender, EventArgs e)
        {
            PoliczClick(SolType.srodowisko);
        }

        private void zapisz_srodowiska_Click(object sender, EventArgs e)
        {
            ZapiszClick(SolType.srodowisko);
        }

        private void policz_kryjowki_Click(object sender, EventArgs e)
        {
            PoliczClick(SolType.kryjowki);
        }

        private void zapisz_kryjowki_Click(object sender, EventArgs e)
        {
            ZapiszClick(SolType.kryjowki);
        }

        private void policz_konkurencja_Click(object sender, EventArgs e)
        {
            PoliczClick(SolType.konkurencja);
        }

        private void zapisz_konkurencja_Click(object sender, EventArgs e)
        {
            ZapiszClick(SolType.konkurencja);
        }

        private void policz_symbioza_Click(object sender, EventArgs e)
        {
            PoliczClick(SolType.symbioza);
        }

        private void zapisz_symbioza_Click(object sender, EventArgs e)
        {
            ZapiszClick(SolType.symbioza);
        }

        private async void PoliczClick(SolType type)
        {
            switch (type)
            {
                case SolType.podstawowy:
                    {
                        double rozOf, rozDrap, skPol, biomas;
                        if (double.TryParse(podstawowy_rozrodczoscOfiar.Text, out rozOf) && double.TryParse(podstawowy_rozrodczoscDrapieznikow.Text, out rozDrap) && double.TryParse(podstawowy_skutecznoscPolowan.Text, out skPol) && double.TryParse(podstawowy_biomasa.Text, out biomas))
                        {
                            try
                            {
                                var points = await _model.Podstawowy((int)podstawowy_czas.Value, (int)podstawowy_ofiary.Value, (int)podstawowy_drapiezniki.Value, rozOf, rozDrap, skPol, biomas);

                                LineSeries sv = new LineSeries() { Title = "Ofiary - V(t)" };
                                LineSeries sp = new LineSeries() { Title = "Drapieżniki - P(t)" };

                                plotView1.Model = new PlotModel();

                                foreach (var item in points)
                                {
                                    sv.Points.Add(new DataPoint(item.T, item.X[0]));
                                    sp.Points.Add(new DataPoint(item.T, item.X[1]));
                                }

                                plotView1.Model.Series.Add(sv);
                                plotView1.Model.Series.Add(sp);

                                dataToSave[0] = points;
                                zapisz_podstawowy.Enabled = true;
                            }
                            catch (ArgumentException ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                            catch (Exception ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Jeden ze współczynników lub żaden nie jest liczbą zmiennoprzecinkową.");
                        }
                    }
                    break;
                case SolType.odlawianie:
                    {
                        double rozOf, rozDrap, skPol, biomas, odl;
                        if (double.TryParse(odlawianie_rozrodczoscOfiar.Text, out rozOf) && double.TryParse(odlawianie_rozrodczoscDrapieznikow.Text, out rozDrap) && double.TryParse(odlawianie_skutecznoscPolowan.Text, out skPol) && double.TryParse(odlawianie_biomasa.Text, out biomas) && double.TryParse(odlawianie_odlawianie.Text, out odl))
                        {
                            try
                            {
                                var points = await _model.Odlawianie((int)odlawianie_czas.Value, (int)odlawianie_ofiary.Value, (int)odlawianie_drapiezniki.Value, rozOf, rozDrap, skPol, biomas, odl);

                                LineSeries sv = new LineSeries() { Title = "Ofiary - V(t)" };
                                LineSeries sp = new LineSeries() { Title = "Drapieżniki - P(t)" };

                                plotView2.Model = new PlotModel();

                                foreach (var item in points)
                                {
                                    sv.Points.Add(new DataPoint(item.T, item.X[0]));
                                    sp.Points.Add(new DataPoint(item.T, item.X[1]));
                                }

                                plotView2.Model.Series.Add(sv);
                                plotView2.Model.Series.Add(sp);

                                dataToSave[1] = points;
                                zapisz_odlawianie.Enabled = true;
                            }
                            catch (ArgumentException ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                            catch (Exception ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Jeden ze współczynników lub żaden nie jest liczbą zmiennoprzecinkową.");
                        }
                    }
                    break;
                case SolType.srodowisko:
                    {
                        double rozOf, rozDrap, skPol, biomas, poj;
                        if (double.TryParse(srodowiska_rozrodczoscOfiar.Text, out rozOf) && double.TryParse(srodowiska_rozrodczoscDrapieznikow.Text, out rozDrap) && double.TryParse(srodowiska_skutecznoscPolowan.Text, out skPol) && double.TryParse(srodowiska_biomasa.Text, out biomas) && double.TryParse(srodowiska_pojemnosc.Text, out poj))
                        {
                            try
                            {
                                var points = await _model.Srodowisko((int)srodowiska_czas.Value, (int)srodowiska_liczebnoscOfiar.Value, (int)srodowiska_liczebnoscDrapieznikow.Value, rozOf, rozDrap, skPol, biomas, poj);

                                LineSeries sv = new LineSeries() { Title = "Ofiary - V(t)" };
                                LineSeries sp = new LineSeries() { Title = "Drapieżniki - P(t)" };

                                plotView3.Model = new PlotModel();

                                foreach (var item in points)
                                {
                                    sv.Points.Add(new DataPoint(item.T, item.X[0]));
                                    sp.Points.Add(new DataPoint(item.T, item.X[1]));
                                }

                                plotView3.Model.Series.Add(sv);
                                plotView3.Model.Series.Add(sp);

                                dataToSave[2] = points;
                                zapisz_srodowiska.Enabled = true;
                            }
                            catch (ArgumentException ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                            catch (Exception ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Jeden ze współczynników lub żaden nie jest liczbą zmiennoprzecinkową.");
                        }
                    }
                    break;
                case SolType.kryjowki:
                    {
                        double rozOf, rozDrap, skPol, biomas, kryj;
                        if (double.TryParse(kryjowki_rozrodczoscOfiar.Text, out rozOf) && double.TryParse(kryjowki_rozrodczoscDrapieznikow.Text, out rozDrap) && double.TryParse(kryjowki_skutecznoscPolowan.Text, out skPol) && double.TryParse(kryjowki_biomasa.Text, out biomas) && double.TryParse(kryjowki_liczbaKryjowek.Text, out kryj))
                        {
                            try
                            {
                                var points = await _model.Kryjowki((int)kryjowki_czas.Value, (int)kryjowki_liczebnoscOfiar.Value, (int)kryjowki_liczebnoscDrapieznikow.Value, rozOf, rozDrap, skPol, biomas, kryj);

                                LineSeries sv = new LineSeries() { Title = "Ofiary - V(t)" };
                                LineSeries sp = new LineSeries() { Title = "Drapieżniki - P(t)" };

                                plotView4.Model = new PlotModel();

                                foreach (var item in points)
                                {
                                    sv.Points.Add(new DataPoint(item.T, item.X[0]));
                                    sp.Points.Add(new DataPoint(item.T, item.X[1]));
                                }

                                plotView4.Model.Series.Add(sv);
                                plotView4.Model.Series.Add(sp);

                                dataToSave[3] = points;
                                zapisz_kryjowki.Enabled = true;
                            }
                            catch (ArgumentException ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                            catch (Exception ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Jeden ze współczynników lub żaden nie jest liczbą zmiennoprzecinkową.");
                        }
                    }
                    break;
                case SolType.konkurencja:
                    {
                        double rozI, rozJ, konIJ, konJI;
                        if (double.TryParse(konkurencja_rozrodczoscGatunkuI.Text, out rozI) && double.TryParse(konkurencja_rozrodczoscGatunkuJ.Text, out rozJ) && double.TryParse(konkurencja_konkurencjaGatunkuIzJ.Text, out konIJ) && double.TryParse(konkurencja_konkurencjaGatunkuJzI.Text, out konJI))
                        {
                            try
                            {
                                var points = await _model.Konkurencja((int)konkurencja_czas.Value, (int)konkurencja_liczebnoscGatunkuI.Value, (int)konkurencja_liczebnoscGatunkuJ.Value, rozI, rozJ, (int)konkurencja_pojemnoscSrodowiskaGatunkuI.Value, (int)konkurencja_pojemnoscSrodowiskaGatunkuJ.Value, konIJ, konJI);

                                LineSeries sv = new LineSeries() { Title = "Gatunek I - V(t)" };
                                LineSeries sp = new LineSeries() { Title = "Gatunek J - P(t)" };

                                plotView5.Model = new PlotModel();

                                foreach (var item in points)
                                {
                                    sv.Points.Add(new DataPoint(item.T, item.X[0]));
                                    sp.Points.Add(new DataPoint(item.T, item.X[1]));
                                }

                                plotView5.Model.Series.Add(sv);
                                plotView5.Model.Series.Add(sp);

                                dataToSave[4] = points;
                                zapisz_konkurencja.Enabled = true;
                            }
                            catch (ArgumentException ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                            catch (Exception ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Jeden ze współczynników lub żaden nie jest liczbą zmiennoprzecinkową.");
                        }
                    }
                    break;
                case SolType.symbioza:
                    {
                        double rozI, rozJ, symIJ, symJI;
                        if (double.TryParse(symbioza_rozrodczoscGatunkuI.Text, out rozI) && double.TryParse(symbioza_rozrodczoscGatunkuJ.Text, out rozJ) && double.TryParse(symbioza_symbiozaGatunkuIzJ.Text, out symIJ) && double.TryParse(symbioza_symbiozaGatunkuJzI.Text, out symJI))
                        {
                            try
                            {
                                var points = await _model.Symbioza((int)symbioza_czas.Value, (int)symbioza_liczebnoscGatunkuI.Value, (int)symbioza_liczebnoscGatunkuJ.Value, rozI, rozJ, (int)symbioza_pojemnoscSrodowiskaGatunkuI.Value, (int)symbioza_pojemnoscSrodowiskaGatunkuJ.Value, symIJ, symJI);

                                LineSeries sv = new LineSeries() { Title = "Gatunek I - V(t)" };
                                LineSeries sp = new LineSeries() { Title = "Gatunek J - P(t)" };

                                plotView6.Model = new PlotModel();

                                foreach (var item in points)
                                {
                                    sv.Points.Add(new DataPoint(item.T, item.X[0]));
                                    sp.Points.Add(new DataPoint(item.T, item.X[1]));
                                }

                                plotView6.Model.Series.Add(sv);
                                plotView6.Model.Series.Add(sp);

                                dataToSave[5] = points;
                                zapisz_symbioza.Enabled = true;
                            }
                            catch (ArgumentException)
                            {
                                MessageBox.Show("Zbyt duże oddziaływania symbiotyczne powodują niepochamowany rozrost obu populacji. Zmniejsz współczynniki symbiotyczne.");
                            }
                            catch (Exception ex)
                            {
                                MessageBox.Show(ex.Message);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Jeden ze współczynników lub żaden nie jest liczbą zmiennoprzecinkową.");
                        }
                    }
                    break;
                default:
                    break;
            }
        }

        private void ZapiszClick(SolType type)
        {
            var saveDialog = new SaveFileDialog();
            saveDialog.Title = "Zapisz";
            saveDialog.DefaultExt = ".dat";
            saveDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
            saveDialog.Filter = "Data file (*.dat)|*.dat|All files (*.*)|*.*";
            saveDialog.FileName = string.Empty;
            saveDialog.OverwritePrompt = true;

            var result = saveDialog.ShowDialog();
            if (result == DialogResult.OK && saveDialog.FileName.Length > 0)
            {
                try
                {
                    StreamWriter sw = new StreamWriter(saveDialog.FileName);
                    sw.WriteLine("{0,6}   {1,24}   {2,24}", "Czas", "V(t)", "P(t)");

                    switch (type)
                    {
                        case SolType.podstawowy:
                            {
                                foreach (var item in dataToSave[0])
                                {
                                    sw.WriteLine("{0,6}   {1,24}   {2,24}", item.T, item.X[0], item.X[1]);
                                }
                            }
                            break;
                        case SolType.odlawianie:
                            {
                                foreach (var item in dataToSave[1])
                                {
                                    sw.WriteLine("{0,6}   {1,24}   {2,24}", item.T, item.X[0], item.X[1]);
                                }
                            }
                            break;
                        case SolType.srodowisko:
                            {
                                foreach (var item in dataToSave[2])
                                {
                                    sw.WriteLine("{0,6}   {1,24}   {2,24}", item.T, item.X[0], item.X[1]);
                                }
                            }
                            break;
                        case SolType.kryjowki:
                            {
                                foreach (var item in dataToSave[3])
                                {
                                    sw.WriteLine("{0,6}   {1,24}   {2,24}", item.T, item.X[0], item.X[1]);
                                }
                            }
                            break;
                        case SolType.konkurencja:
                            {
                                foreach (var item in dataToSave[4])
                                {
                                    sw.WriteLine("{0,6}   {1,24}   {2,24}", item.T, item.X[0], item.X[1]);
                                }
                            }
                            break;
                        case SolType.symbioza:
                            {
                                foreach (var item in dataToSave[5])
                                {
                                    sw.WriteLine("{0,6}   {1,24}   {2,24}", item.T, item.X[0], item.X[1]);
                                }
                            }
                            break;
                        default:
                            break;
                    }

                    sw.Flush();
                    sw.Close();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                    throw;
                }
            }


        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            radioButton1.Parent = radioButton2.Parent = radioButton3.Parent = radioButton4.Parent = tabControl1.SelectedTab;
            if (radioButton1.Checked) radioButton1_CheckedChanged(radioButton1, new EventArgs());
            else if (radioButton2.Checked) radioButton2_CheckedChanged(radioButton2, new EventArgs());
            else if (radioButton3.Checked) radioButton3_CheckedChanged(radioButton3, new EventArgs());
            else if (radioButton4.Checked) radioButton4_CheckedChanged(radioButton4, new EventArgs());
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton1.Checked)
            {
                foreach (var item in radioButton1.Parent.Controls)
                {
                    switch (item.GetType().Name)
                    {
                        case "TextBox":
                            (item as TextBox).Text = string.Empty;
                            break;
                        case "NumericUpDown":
                            (item as NumericUpDown).Value = 1;
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton2.Checked)
            {
                string rozrOf = "0,7", rozDr = "0,2", skPol = "0,1", biomas = "0,5";
                int time = 250, liczOf = 20, liczDr = 5;
                foreach (var item in radioButton1.Parent.Controls)
                {
                    switch (item.GetType().Name)
                    {
                        case "TextBox":
                            {
                                switch ((item as TextBox).Name)
                                {
                                    case "podstawowy_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "podstawowy_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "podstawowy_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "podstawowy_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "odlawianie_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "odlawianie_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "odlawianie_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "odlawianie_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "odlawianie_odlawianie":
                                        (item as TextBox).Text = "0,4";
                                        break;
                                    case "srodowiska_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "srodowiska_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "srodowiska_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "srodowiska_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "kryjowki_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "kryjowki_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "kryjowki_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "kryjowki_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "konkurencja_rozrodczoscGatunkuI":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "konkurencja_rozrodczoscGatunkuJ":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "konkurencja_konkurencjaGatunkuIzJ":
                                        (item as TextBox).Text = "0,2";
                                        break;
                                    case "konkurencja_konkurencjaGatunkuJzI":
                                        (item as TextBox).Text = "0,5";
                                        break;
                                    case "symbioza_rozrodczoscGatunkuI":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "symbioza_rozrodczoscGatunkuJ":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "symbioza_symbiozaGatunkuIzJ":
                                        (item as TextBox).Text = "0,2";
                                        break;
                                    case "symbioza_symbiozaGatunkuJzI":
                                        (item as TextBox).Text = "0,5";
                                        break;
                                    default:
                                        break;
                                }
                            }
                            break;
                        case "NumericUpDown":
                            switch ((item as NumericUpDown).Name)
                            {
                                case "podstawowy_ofiary":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "podstawowy_drapiezniki":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "podstawowy_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "odlawianie_ofiary":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "odlawianie_drapiezniki":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "odlawianie_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "srodowiska_liczebnoscOfiar":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "srodowiska_liczebnoscDrapieznikow":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "srodowiska_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "srodowiska_pojemnosc":
                                    (item as NumericUpDown).Value = 4;
                                    break;
                                case "kryjowki_liczebnoscOfiar":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "kryjowki_liczebnoscDrapieznikow":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "kryjowki_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "kryjowki_liczbaKryjowek":
                                    (item as NumericUpDown).Value = 5;
                                    break;
                                case "konkurencja_liczebnoscGatunkuI":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "konkurencja_liczebnoscGatunkuJ":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "konkurencja_pojemnoscSrodowiskaGatunkuI":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "konkurencja_pojemnoscSrodowiskaGatunkuJ":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "konkurencja_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "symbioza_liczebnoscGatunkuI":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "symbioza_liczebnoscGatunkuJ":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "symbioza_pojemnoscSrodowiskaGatunkuI":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "symbioza_pojemnoscSrodowiskaGatunkuJ":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "symbioza_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                default:
                                    break;
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        private void radioButton3_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton3.Checked)
            {
                string rozrOf = "0,7", rozDr = "0,2", skPol = "0,5", biomas = "0,5";
                int time = 250, liczOf = 20, liczDr = 5;
                foreach (var item in radioButton1.Parent.Controls)
                {
                    switch (item.GetType().Name)
                    {
                        case "TextBox":
                            {
                                switch ((item as TextBox).Name)
                                {
                                    case "podstawowy_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "podstawowy_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "podstawowy_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "podstawowy_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "odlawianie_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "odlawianie_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "odlawianie_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "odlawianie_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "odlawianie_odlawianie":
                                        (item as TextBox).Text = "0,1";
                                        break;
                                    case "srodowiska_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "srodowiska_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "srodowiska_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "srodowiska_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "kryjowki_rozrodczoscOfiar":
                                        (item as TextBox).Text = "0,4";
                                        break;
                                    case "kryjowki_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = "0,1";
                                        break;
                                    case "kryjowki_skutecznoscPolowan":
                                        (item as TextBox).Text = "0,1";
                                        break;
                                    case "kryjowki_biomasa":
                                        (item as TextBox).Text = "0,5";
                                        break;
                                    case "konkurencja_rozrodczoscGatunkuI":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "konkurencja_rozrodczoscGatunkuJ":
                                        (item as TextBox).Text = "0,3";
                                        break;
                                    case "konkurencja_konkurencjaGatunkuIzJ":
                                        (item as TextBox).Text = "0,2";
                                        break;
                                    case "konkurencja_konkurencjaGatunkuJzI":
                                        (item as TextBox).Text = "0,5";
                                        break;
                                    case "symbioza_rozrodczoscGatunkuI":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "symbioza_rozrodczoscGatunkuJ":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "symbioza_symbiozaGatunkuIzJ":
                                        (item as TextBox).Text = "0,02";
                                        break;
                                    case "symbioza_symbiozaGatunkuJzI":
                                        (item as TextBox).Text = "0,05";
                                        break;
                                    default:
                                        break;
                                }
                            }
                            break;
                        case "NumericUpDown":
                            switch ((item as NumericUpDown).Name)
                            {
                                case "podstawowy_ofiary":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "podstawowy_drapiezniki":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "podstawowy_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "odlawianie_ofiary":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "odlawianie_drapiezniki":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "odlawianie_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "srodowiska_liczebnoscOfiar":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "srodowiska_liczebnoscDrapieznikow":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "srodowiska_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "srodowiska_pojemnosc":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "kryjowki_liczebnoscOfiar":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "kryjowki_liczebnoscDrapieznikow":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "kryjowki_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "kryjowki_liczbaKryjowek":
                                    (item as NumericUpDown).Value = 5;
                                    break;
                                case "konkurencja_liczebnoscGatunkuI":
                                    (item as NumericUpDown).Value = 5;
                                    break;
                                case "konkurencja_liczebnoscGatunkuJ":
                                    (item as NumericUpDown).Value = 9;
                                    break;
                                case "konkurencja_pojemnoscSrodowiskaGatunkuI":
                                    (item as NumericUpDown).Value = 15;
                                    break;
                                case "konkurencja_pojemnoscSrodowiskaGatunkuJ":
                                    (item as NumericUpDown).Value = 15;
                                    break;
                                case "konkurencja_czas":
                                    (item as NumericUpDown).Value = 100;
                                    break;
                                case "symbioza_liczebnoscGatunkuI":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "symbioza_liczebnoscGatunkuJ":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "symbioza_pojemnoscSrodowiskaGatunkuI":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "symbioza_pojemnoscSrodowiskaGatunkuJ":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "symbioza_czas":
                                    (item as NumericUpDown).Value = 50;
                                    break;
                                default:
                                    break;
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        private void radioButton4_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton4.Checked)
            {
                string rozrOf = "0,7", rozDr = "0,5", skPol = "0,5", biomas = "0,5";
                int time = 250, liczOf = 20, liczDr = 5;
                foreach (var item in radioButton1.Parent.Controls)
                {
                    switch (item.GetType().Name)
                    {
                        case "TextBox":
                            {
                                switch ((item as TextBox).Name)
                                {
                                    case "podstawowy_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "podstawowy_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "podstawowy_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "podstawowy_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "odlawianie_rozrodczoscOfiar":
                                        (item as TextBox).Text = "1,1";
                                        break;
                                    case "odlawianie_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "odlawianie_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "odlawianie_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "odlawianie_odlawianie":
                                        (item as TextBox).Text = "0,6";
                                        break;
                                    case "srodowiska_rozrodczoscOfiar":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "srodowiska_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "srodowiska_skutecznoscPolowan":
                                        (item as TextBox).Text = skPol;
                                        break;
                                    case "srodowiska_biomasa":
                                        (item as TextBox).Text = biomas;
                                        break;
                                    case "kryjowki_rozrodczoscOfiar":
                                        (item as TextBox).Text = "0,4";
                                        break;
                                    case "kryjowki_rozrodczoscDrapieznikow":
                                        (item as TextBox).Text = "0,2";
                                        break;
                                    case "kryjowki_skutecznoscPolowan":
                                        (item as TextBox).Text = "0,1";
                                        break;
                                    case "kryjowki_biomasa":
                                        (item as TextBox).Text = "0,5";
                                        break;
                                    case "konkurencja_rozrodczoscGatunkuI":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "konkurencja_rozrodczoscGatunkuJ":
                                        (item as TextBox).Text = "0,3";
                                        break;
                                    case "konkurencja_konkurencjaGatunkuIzJ":
                                        (item as TextBox).Text = "1,2";
                                        break;
                                    case "konkurencja_konkurencjaGatunkuJzI":
                                        (item as TextBox).Text = "0,5";
                                        break;
                                    case "symbioza_rozrodczoscGatunkuI":
                                        (item as TextBox).Text = rozrOf;
                                        break;
                                    case "symbioza_rozrodczoscGatunkuJ":
                                        (item as TextBox).Text = rozDr;
                                        break;
                                    case "symbioza_symbiozaGatunkuIzJ":
                                        (item as TextBox).Text = "0,06";
                                        break;
                                    case "symbioza_symbiozaGatunkuJzI":
                                        (item as TextBox).Text = "0,07";
                                        break;
                                    default:
                                        break;
                                }
                            }
                            break;
                        case "NumericUpDown":
                            switch ((item as NumericUpDown).Name)
                            {
                                case "podstawowy_ofiary":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "podstawowy_drapiezniki":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "podstawowy_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "odlawianie_ofiary":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "odlawianie_drapiezniki":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "odlawianie_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "srodowiska_liczebnoscOfiar":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "srodowiska_liczebnoscDrapieznikow":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "srodowiska_czas":
                                    (item as NumericUpDown).Value = 750;
                                    break;
                                case "srodowiska_pojemnosc":
                                    (item as NumericUpDown).Value = 80;
                                    break;
                                case "kryjowki_liczebnoscOfiar":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "kryjowki_liczebnoscDrapieznikow":
                                    (item as NumericUpDown).Value = liczDr;
                                    break;
                                case "kryjowki_czas":
                                    (item as NumericUpDown).Value = time;
                                    break;
                                case "kryjowki_liczbaKryjowek":
                                    (item as NumericUpDown).Value = 1;
                                    break;
                                case "konkurencja_liczebnoscGatunkuI":
                                    (item as NumericUpDown).Value = 5;
                                    break;
                                case "konkurencja_liczebnoscGatunkuJ":
                                    (item as NumericUpDown).Value = 9;
                                    break;
                                case "konkurencja_pojemnoscSrodowiskaGatunkuI":
                                    (item as NumericUpDown).Value = 15;
                                    break;
                                case "konkurencja_pojemnoscSrodowiskaGatunkuJ":
                                    (item as NumericUpDown).Value = 15;
                                    break;
                                case "konkurencja_czas":
                                    (item as NumericUpDown).Value = 100;
                                    break;
                                case "symbioza_liczebnoscGatunkuI":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "symbioza_liczebnoscGatunkuJ":
                                    (item as NumericUpDown).Value = liczOf;
                                    break;
                                case "symbioza_pojemnoscSrodowiskaGatunkuI":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "symbioza_pojemnoscSrodowiskaGatunkuJ":
                                    (item as NumericUpDown).Value = 10;
                                    break;
                                case "symbioza_czas":
                                    (item as NumericUpDown).Value = 50;
                                    break;
                                default:
                                    break;
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}
